/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	WindowColorsWindow.h
	
	Contains:	Class definition of app-specific Window.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _WINDOW_COLORS_WINDOW_H
#define _WINDOW_COLORS_WINDOW_H

#ifndef _WINDOW_H
#include <Window.h>
#endif

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _WINDOW_COLORS_APPLICATION_H
#include "WindowColorsApplication.h"
#endif

#ifndef _WINDOW_COLORS_PANEL_H
#include "WindowColorsPanel.h"
#endif

#ifndef _ABOUT_PANEL_H
#include "AboutPanel.h"
#endif


/* ...............................................................	
	Constants
   ............................................................... */

const BRect 	WINDOW_FRAME = BRect(0, 0, 430, 340);
const BPoint	DEFAULT_WINDOW_LOCATION = BPoint(150, 150);


/* ...............................................................	
	WindowColorsWindow class
   ............................................................... */

class AboutPanel;
class WindowColorsPanel;
class WindowColorsWindow : public BWindow
{
	public:
						WindowColorsWindow();
						
	WindowColorsPanel	*Panel();
			void		KeepOnScreen();
			
			void		Quit();
			bool		QuitRequested();
			void		ScreenChanged(BRect screenSize, 
									  color_space screenDepth);
			void		ShowAboutPanel(bool show);
			
	private:
	
		AboutPanel		*_aboutPanel;
	WindowColorsPanel	*_panel;
};

#endif